/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import com.james.tinkerscalibration.modifiers.DarknessModifier;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ArmorDichroicModifier
extends Modifier
implements ProtectionModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> DICHROIC = TConstruct.createKey((String)"dichroic_armor");

    public ArmorDichroicModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::livingKnockback);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(DICHROIC, false, null));
    }

    private void livingKnockback(LivingKnockBackEvent event) {
        LivingEntity living = event.getEntity();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            int light;
            int levels = (Integer)data.get(DICHROIC, (Object)0);
            if (levels > 0 && (light = DarknessModifier.getLight(living.m_9236_(), living.m_20183_())) < 7) {
                event.setStrength(event.getStrength() * (1.0f - (float)(7 - light) / 20.0f * (float)levels));
            }
        });
    }

    public float getProtectionModifier(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull EquipmentContext context, @Nonnull EquipmentSlot slotType, DamageSource source, float modifierValue) {
        LivingEntity living;
        int light;
        if (!source.m_19378_() && (light = DarknessModifier.getLight((living = context.getEntity()).m_9236_(), living.m_20183_())) > 7) {
            modifierValue *= 1.0f + (float)(light - 7) / 20.0f * (float)modifier.getLevel();
        }
        return modifierValue;
    }
}

